// Copyright 1994 by Jon Dart.  All Rights Reserved.

#ifndef _ECOINFO_H
#define _ECOINFO_H

#include "move.h"
#include "hashable.h"
#include "pool.h"
#include "types.h"
#include <stddef.h>

class ECO_Info : public Hashable
{
    // this class represents one entry in the ECO hash table.

    ECO_Info();

    public:

    ECO_Info( const char *code, const char *opening_name,
              hash_t hashcode );

    ECO_Info(const ECO_Info &);
    
    virtual ~ECO_Info();

    ECO_Info &operator = (const ECO_Info &);
    
    const char * get_eco() const
    {
        return my_eco;
    }
    
    const char * get_opening_name() const
    {
        return my_opening_name;
    }

    // memory allocation

    void *operator new (size_t size)
    {
	return allocator.allocate(size);
    }
    
    void *operator new (size_t, void *p)
    {
	return p;    
    }

    void operator delete( void *p )
    {
	allocator.free(p);    
    }
    
    static void freeAll( BOOL final )
    {
	allocator.freeAll(final);
    }
    
    // methods of class Hashable

    BOOL is_equal ( const Hashable &c) const
    {
	ECO_Info *p = (ECO_Info*)&c;
        return (my_hashcode == p->my_hashcode);
    }
    
    hash_t hash_code() const
    {
	return my_hashcode;
    }
    
    private:

    static Pool allocator;
    hash_t my_hashcode;
    char *my_opening_name;
    char my_eco[3];
};

#endif
